/*
 * Decompiled with CFR 0.152.
 */
package com.night.star.shopjei;

import com.night.star.shopjei.ShopJeiCategory;
import com.night.star.shopjei.ShopJeiEntry;
import com.night.star.shopjei.event.ShopDataLoadedEvent;
import java.util.LinkedList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopTab;
import net.sixik.sdmshoprework.common.shop.type.ShopItemEntryType;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ShopJeiJEIPlugin
implements IModPlugin {
    public static IRecipeManager RECIPE_MANAGER;
    public static ResourceLocation UID;
    public static final RecipeType<ShopJeiEntry> PROFESSION_TYPE;

    public ShopJeiJEIPlugin() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ShopJeiCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42616_), new RecipeType[]{PROFESSION_TYPE});
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        RECIPE_MANAGER = jeiRuntime.getRecipeManager();
    }

    @SubscribeEvent
    public void onShopDataLoaded(ShopDataLoadedEvent event) {
        if (RECIPE_MANAGER != null) {
            LinkedList<ShopJeiEntry> entries = new LinkedList<ShopJeiEntry>();
            AbstractShopTab shopTab = event.getShopTab();
            String title = shopTab.title.getString();
            AbstractShopEntry entry = event.getEntry();
            if (entry.getEntryType() instanceof ShopItemEntryType) {
                entries.add(new ShopJeiEntry(title, entry));
            }
            RECIPE_MANAGER.addRecipes(PROFESSION_TYPE, entries);
        }
    }

    static {
        UID = ResourceLocation.fromNamespaceAndPath((String)"shopjei", (String)"jei_plugin");
        PROFESSION_TYPE = RecipeType.create((String)"shopjei", (String)"shopjei", ShopJeiEntry.class);
    }
}

